# gof_clerids.R
# Goodness-of-fit test for T. dubius data

# Load necessary libraries
library(DescTools)

# Data values
obsfreq <- c(60,70)

# Probabilities and expected frequencies under H0
p0 <- c(0.5,0.5)
expfreq <- sum(obsfreq)*p0

# Observed and expected frequencies
rbind(obsfreq,expfreq)

# X2 goodness-of-fit test
chisq.test(obsfreq,p=p0)

# X2 exact test using simulation
chisq.test(obsfreq,p=p0,simulate.p.value=TRUE)

# G2 goodness-of-fit test
GTest(obsfreq,p=p0)    


